<?php

Class Personnage {

    // INITIALISATION
    private $id;
    private $name;
    private $img;
    private $pv = 100;
    private $atk = 20;
    
    public const MAXLIFE=200;
    private static $compteur=0;


    // HYDRATATION

    private function hydrate(array $donnees){
        foreach ($donnees as $key => $value) {
            // On récupère le nom du setter correspondant à l'attribut.
            $method = 'set'.ucfirst($key);
            // Si le setter correspondant existe.
            if (method_exists($this, $method)) {
                // On appelle le setter.
                $this->$method($value);
                //$this->$key = $ value;
            }
        }
    }

    // GETTEURS

    public function getId(){
        return $this->id;
    }

    public function getName(){
        return $this->name;
    }

    public function getImg(){
        return $this->img;
    }

    public function getAtk(){
        return $this->atk;
    }

    public function getPv(){
        return $this->pv;
    }

    public static function getCompteur(){
        return self::$compteur;
    }

    // SETTEURS

    public function setId($id){
        $this->id=$id;
    }

    public function setPv($pv){
        $this->pv=$pv;
        if ($pv<0){$this->pv=0;}
        if ($pv>self::MAXLIFE){$this->pv=self::MAXLIFE;}   
    }

    public function setImg($img){
        $this->img=$img;
    }

    public function setAtk($atk){
        $this->atk=$atk;
    }

    public function setName($name){
        $this->name=$name;
    }

    // CONSTRUCTEUR

    public function __construct(array $donnees){
        $this->hydrate($donnees);
        self::$compteur++;
    }

    // FUNCTIONS

    public function soigner($x){
        if ($this->pv+$x>self::MAXLIFE){
            $this->pv=self::MAXLIFE;
        }
        else{
            $this->pv+=$x;
        }
    }
    public function attaquer(Personnage $perso){
        $perso->pv-=$this->atk;
    }

    public function is_alive(){
        return $this->pv>0;
    }

}

?>